/*{
    "DESCRIPTION": "Top-to-Bottom Fade",
    "CREDIT": "",
    "ISFVSN": "2",
    "CATEGORIES": [
        "Composition"
    ],
    "INPUTS": [
        {
            "NAME": "inputImage",
            "TYPE": "image"
        },
        {
            "NAME": "topImage",
            "TYPE": "image"
        },
        {
            "NAME": "dryWet",
            "TYPE": "float",
            "DEFAULT": 1.0,
            "MIN": 0.0,
            "MAX": 1.0
        }
    ]
    
}*/

const float smoothness = 0.3;

void main() {
    float y = isf_FragNormCoord.y; // Vertical coordinate
    float x = 1.0 - dryWet;
    
    // Smoothstep for smooth transition or sharp wipe
    float m = smoothstep(-smoothness, 0.0, (1.0 - y) - x * (1.0 + smoothness));
    
    // Blend the two images based on the calculated gradient
    gl_FragColor = mix(IMG_NORM_PIXEL(inputImage, isf_FragNormCoord), IMG_NORM_PIXEL(topImage, isf_FragNormCoord), m);
}
